package com.bxm.localnews.news.approve;

import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.model.vo.AdminForumPostApproveHistory;

import java.util.List;

/**
 * 帖子审核相关接口
 *
 * @author liujia
 * @date 1/18/21 2:33 PM
 **/
public interface PostApproveService {

    /**
     * 批量审核
     *
     * @param ids     帖子ID，根据逗号分隔
     * @param status  审核后的状态
     * @param comment 审核评论
     * @param userId  操作人
     */
    void batchApprove(String ids, Integer status, String comment, Long userId);

    /**
     * 帖子审核
     *
     * @param postId   帖子ID
     * @param status   审核后的状态
     * @param comment  审核评论
     * @param operator 操作人
     */
    void approve(Long postId, PostStatusEnum status, String comment, Long operator);

    /**
     * 获取帖子审核历史列表
     *
     * @param id
     * @param action
     * @return
     */
    List<AdminForumPostApproveHistory> getApproveHistoryList(Long id, Integer action);
}
