package com.bxm.localnews.news.approve.context;

import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import lombok.Data;

/**
 * 帖子审核相关上下文
 *
 * @author liujia
 * @date 1/18/21 6:01 PM
 **/
@Data
public class PostApproveContext {
    /**
     * 原始帖子信息
     */
    private AdminForumPost postInfo;

    /**
     * 更新的帖子信息
     */
    private AdminForumPost updatePost;

    /**
     * 审核操作运营人员
     */
    private Long operator;

    /**
     * 变更后的状态
     */
    private PostStatusEnum modifyStatus;

    /**
     * 运营评论
     */
    private String comment;
}
