package com.bxm.localnews.news.approve.filter;

import com.bxm.localnews.news.approve.context.PostApproveContext;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.recommend.RecommendPostService;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;

import java.util.Objects;

import static com.bxm.localnews.news.constant.LogicGroupConstant.ADMIN_POST_APPROVE_FILTER;

/**
 * 审核拒绝、本地圈屏蔽、仅用户可见，则取消推荐
 *
 * @author liujia
 * @date 1/18/21 6:53 PM
 **/
@FilterBean(group = ADMIN_POST_APPROVE_FILTER)
@AllArgsConstructor
public class PostApproveCancelRecommendFilter implements IFilter<PostApproveContext> {

    private final RecommendPostService recommendPostService;

    @Override
    public void doFilter(PostApproveContext postApproveContext) {
        Integer status = postApproveContext.getPostInfo().getStatus();
        if (Objects.equals(PostStatusEnum.REJECTED.getCode(), status)
                || Objects.equals(status, PostStatusEnum.SELF.getCode())
                || Objects.equals(status, PostStatusEnum.BLOCKED.getCode())) {

            postApproveContext.getUpdatePost().setIsRecommend((byte) 0);

            recommendPostService.cancelRecommend(postApproveContext.getPostInfo().getId());
        }
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
