package com.bxm.localnews.news.approve.filter;

import com.bxm.localnews.news.approve.context.PostApproveContext;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.note.NoteService;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;

import static com.bxm.localnews.news.constant.LogicGroupConstant.ADMIN_POST_APPROVE_FILTER;

/**
 * 审核通过后清理相关缓存和数据
 *
 * @author liujia
 * @date 1/18/21 6:57 PM
 **/
@FilterBean(group = ADMIN_POST_APPROVE_FILTER)
@AllArgsConstructor
public class PostApproveCleanFilter implements IFilter<PostApproveContext> {

    private NoteService noteService;

    @Override
    public void doFilter(PostApproveContext context) {
        AdminForumPost postInfo = context.getPostInfo();

        //删除用户小纸条缓存
        if (PostTypeEnum.NOTE.getCode() == postInfo.getPostType()) {
            noteService.removeCache(postInfo.getUserId());
        }
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
