package com.bxm.localnews.news.approve.filter;

import com.bxm.localnews.news.approve.context.PostApproveContext;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;

import java.util.Date;
import java.util.Objects;

import static com.bxm.localnews.news.constant.LogicGroupConstant.ADMIN_POST_APPROVE_FILTER;

/**
 * 审核前置数据处理
 *
 * @author liujia
 * @date 1/18/21 6:46 PM
 **/
@FilterBean(group = ADMIN_POST_APPROVE_FILTER)
public class PostApprovePreFilter implements IFilter<PostApproveContext> {
    @Override
    public void doFilter(PostApproveContext context) {
        AdminForumPost postInfo = context.getPostInfo();
        AdminForumPost updatePost = context.getUpdatePost();

        updatePost.setModifyTime(new Date());
        updatePost.setStatus(context.getModifyStatus().getCode());
        //用户更新的帖子状态设置为 0(用户更新已处理)
        if (Objects.nonNull(postInfo.getIsUserUpdate()) && postInfo.getIsUserUpdate() == 1) {
            updatePost.setIsUserUpdate((byte) 0);
        }
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
