package com.bxm.localnews.news.constant;

/**
 * 业务逻辑分组常量定义
 *
 * @author liujia
 * @date 1/14/21 9:41 AM
 **/
public class LogicGroupConstant {
    private LogicGroupConstant() {
    }

    /**
     * 帖子详情的前置判断规则逻辑
     */
    public static final String POST_DETAIL_RULE = "POST_DETAIL_RULE";

    /**
     * 帖子详情的内容填充过滤器
     */
    public static final String POST_DETAIL_FILTER = "POST_DETAIL_FILTER";

    /**
     * 帖子列表过滤器
     */
    public static final String POST_LIST_FILTER = "POST_LIST_FILTER";

    /**
     * 用户发帖相关处理过滤器
     */
    public static final String USER_POST_CREATE_FILTER = "USER_POST_CREATE_FILTER";

    /**
     * 用户发帖的相关逻辑规则判断
     */
    public static final String USER_POST_CREATE_RULE = "USER_POST_CREATE_RULE";

    /**
     * 用户发布小纸条的相关逻辑判断
     */
    public static final String USER_NOTE_CREATE_RULE = "USER_NOTE_CREATE_RULE";

    /**
     * 小纸条发布相关的逻辑过滤器
     */
    public static final String USER_NOTE_CREATE_FILTER = "USER_NOTE_CREATE_FILTER";

    /**
     * 运营发帖的相关逻辑规则判断
     */
    public static final String ADMIN_POST_CREATE_RULE = "ADMIN_POST_CREATE_RULE";

    /**
     * 运营发帖的相关信息处理逻辑
     */
    public static final String ADMIN_POST_CREATE_FILTER = "ADMIN_POST_CREATE_FILTER";

    /**
     * 运营审核帖子相关流程
     */
    public static final String ADMIN_POST_APPROVE_FILTER = "ADMIN_POST_APPROVE_FILTER";

    /**
     * 话题信息填充计算过滤器
     */
    public static final String TOPIC_FILL_FILTER = "TOPIC_FILL_FILTER";
}
