package com.bxm.localnews.news.constant;

import com.bxm.localnews.news.approve.filter.PostApproveCancelRecommendFilter;
import com.bxm.localnews.news.approve.filter.PostApproveCleanFilter;
import com.bxm.localnews.news.approve.filter.PostApprovePreFilter;
import com.bxm.localnews.news.create.filter.*;
import com.bxm.localnews.news.create.rule.*;
import com.bxm.localnews.news.detail.filter.ContentAssemblyFilter;
import com.bxm.localnews.news.detail.filter.ExtendContentFillFilter;
import com.bxm.localnews.news.detail.filter.PlaceHolderFilter;
import com.bxm.localnews.news.detail.rule.BlackPostRule;
import com.bxm.localnews.news.detail.rule.ViewLimitRule;

import java.util.HashMap;
import java.util.Map;

/**
 * 排序统一定义，方便调整
 * 排序可能涉及到变量的变更，修改时请谨慎阅读过滤器的内部逻辑
 *
 * @author liujia
 * @date 1/14/21 9:43 AM
 **/
public class OrderConstant {
    private OrderConstant() {
    }

    private static Map<Class<?>, Integer> orderMap = new HashMap<>();

    public static Integer getOrder(Class<?> clasz) {
        Integer order = orderMap.get(clasz);
        if (order == null) {
            return 0;
        }
        return order;
    }

    static {
        int order = 0;

        // 帖子详情获取相关前置规则
        orderMap.put(ViewLimitRule.class, ++order);
        orderMap.put(BlackPostRule.class, ++order);

        // 帖子详情内容处理相关过滤器，其他过滤器是并行的关系，非并行的过滤器需要设定顺序
        orderMap.put(ExtendContentFillFilter.class, ++order);
        orderMap.put(PlaceHolderFilter.class, ++order);
        orderMap.put(ContentAssemblyFilter.class, ++order);

        // 用户发帖的相关验证逻辑分组
        orderMap.put(UserPostStatusCheckRule.class, ++order);
        orderMap.put(UserPostSensitiveWordRule.class, ++order);
        orderMap.put(UserPostNewbieRule.class, ++order);

        // 用户发帖相关的处理逻辑
        orderMap.put(UserPostContentAssembleFilter.class, ++order);
        orderMap.put(UserPostAttributeFillFilter.class, ++order);

        // 运营后台发帖校验
        orderMap.put(AdminPostCheckRule.class, ++order);
        orderMap.put(AdminPostAwardRule.class, ++order);

        // 运营管理后台发帖
        orderMap.put(AdminPostFillAttributeFilter.class, ++order);
        orderMap.put(AdminPostTopicFillFilter.class, ++order);
        orderMap.put(AdminPostPluginFilter.class, ++order);
        orderMap.put(AdminPostActivityFilter.class, ++order);
        orderMap.put(AdminPostShareCashFilter.class, ++order);

        // 用户发布小纸条相关的过滤器
        orderMap.put(UserNotePreFillFilter.class, ++order);
        orderMap.put(UserNoteResponseFilter.class, ++order);

        // 运营审核帖子相关的逻辑过滤器
        orderMap.put(PostApprovePreFilter.class, ++order);
        orderMap.put(PostApproveCancelRecommendFilter.class, ++order);
        orderMap.put(PostApproveCleanFilter.class, ++order);
    }
}
