package com.bxm.localnews.news.content;

import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import org.springframework.core.Ordered;
import org.springframework.data.domain.Sort;

/**
 * @author gonzo
 * @date 2020-09-24 18:13
 **/
public interface ContentReplace extends Ordered {

    /**
     * html 类型转换器的默认顺序
     */
    int HTML_ORDER = 1;

    /**
     * 字符串类型转换器的默认顺序
     */
    int STRING_ORDER = HTML_ORDER + 1;

    /**
     * 将context中的content进行占位符替换替换
     *
     * @param context 包含了要替换的源字符串和需要替换的map键值
     */
    void replace(ContentContext context);

    /**
     * 当前支持的替换类型
     *
     * @return 支持的替换类型
     */
    ForumContentPlaceHolderEnum[] supports();

}
