package com.bxm.localnews.news.content;

import com.bxm.localnews.news.model.dto.ContentContext;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.Comparator;
import java.util.List;

import static com.alibaba.fastjson.JSON.toJSONString;
import static java.util.Objects.isNull;

/**
 * @author gonzo
 * @date 2020-09-24 18:13
 **/
@Slf4j
@Service
@AllArgsConstructor
public class ContentReplacer {

    private final List<ContentReplace> contentReplaceList;

    @PostConstruct
    public void init() {
        contentReplaceList.sort(Comparator.comparingInt(ContentReplace::getOrder));
    }

    /**
     * 将context中的content进行占位符替换替换
     *
     * @param context 包含了要替换的源字符串和需要替换的map键值
     */
    public void replace(ContentContext context) {

        if (isNull(context) || isNull(context.getReplaceMap()) || CollectionUtils.isEmpty(context.getReplaceMap())) {
            log.warn("替换占位符失败，数据缺失 context: {}", toJSONString(context));
            return;
        }

        // 循环替换
        contentReplaceList.forEach(p -> p.replace(context));
    }

}
