package com.bxm.localnews.news.content.replace;

import com.bxm.localnews.news.content.ContentReplace;
import com.bxm.localnews.news.model.dto.ContentContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSONString;
import static java.util.Objects.isNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author gonzo
 * @date 2020-09-24 18:34
 **/
@Slf4j
public abstract class AbstractContentReplace implements ContentReplace {

    @Override
    public void replace(ContentContext context) {
        try {
            if (preCheck(context)) {
                doReplace(context);
            }
        } catch (Exception e) {
            log.error("类型: {} 替换失败 context: {}", toJSONString(context), e);
        }
    }

    protected boolean preCheck(ContentContext context) {
        if (isNull(context) || isNull(context.getReplaceMap()) || CollectionUtils.isEmpty(context.getReplaceMap())) {
            return false;
        }
        return Arrays.stream(supports()).anyMatch(p -> Objects.nonNull(context.getReplaceMap().get(p))
                && context.getContent().contains(p.getPlaceHolder())
                && Objects.nonNull(context.getReplaceMap().get(p).get()));
    }

    /**
     * real do
     * 默认的处理方法是把value当做字符串获取并替换
     *
     * @param context context
     */
    protected void doReplace(ContentContext context) {
        Arrays.stream(supports()).forEach(p -> {
            if (Objects.nonNull(context.getReplaceMap()) && Objects.nonNull(context.getReplaceMap().get(p))) {
                Object content = context.getReplaceMap().get(p).get();
                if (Objects.nonNull(content) && isNotBlank(Objects.toString(content))) {
                    context.setContent(context.getContent().replace(p.getPlaceHolder(), Objects.toString(content)));
                }
            }
        });
    }
}
