package com.bxm.localnews.news.content.replace.html;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.news.config.NewsContentReplaceProperties;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.bxm.localnews.news.model.param.ReplaceTopicNeedParam;
import com.bxm.localnews.url.ProtocolFactory;
import lombok.extern.slf4j.Slf4j;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.function.Supplier;

import static com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum.LOTTERY_FLAUNT_JUMP_URL;
import static com.bxm.newidea.component.tools.StringUtils.isLessThan;
import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.apache.commons.lang3.StringUtils.join;

/**
 * 炫耀帖子跳转地址
 *
 * @author gonzo
 * @date 2020-09-24 18:45
 **/
@Slf4j
@Component
public class LotteryFlauntJumpUrlReplace extends AbstractHtmlContentReplace {

    @Autowired
    private DomainIntegrationService domainIntegrationService;

    @Autowired
    private NewsContentReplaceProperties newsContentReplaceProperties;

    public static final String LOTTERY_FLAUNT_JUMP_URL_SELECT = "a[" + LOTTERY_FLAUNT_JUMP_URL.getPlaceHolder() + "]";

    @Override
    protected void doReplace(ContentContext context) {
        Elements elements;
        if (!(elements = context.getDocument().select(LOTTERY_FLAUNT_JUMP_URL_SELECT)).isEmpty()) {
            elements.forEach(el -> {
                // 获取替换需要的参数
                Supplier<ReplaceTopicNeedParam> basicParamSupplier = context.getReplaceValue(supports()[0]);
                ReplaceTopicNeedParam param = basicParamSupplier.get();

                // 判断是站内还是站外
                String protocol;
                if (Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform())
                        || Objects.equals(PlatformEnum.IOS.getCode(), param.getPlatform())) {

                    String url;
                    // 老版本android 对#的处理有点问题，服务端擦屁股
                    if (Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform())
                            // 如果是老版本android
                            && isNotBlank(param.getCurVer())
                            && isLessThan(param.getCurVer(), "3.8.0")) {

                        // 获取服务器域名
                        url = domainIntegrationService.getServerHostBaseUrl();
                        // 拼接成一个服务器会跳转的域名
                        url = join(url, newsContentReplaceProperties.getLotteryFlauntOldAndroidProtocol());

                    } else {
                        // 获取站内的base url
                        url = domainIntegrationService.getInnerH5BaseUrl();
                        // 拼接
                        url = join(url, newsContentReplaceProperties.getLotteryFlauntProtocol());
                    }

                    url = String.format(url, param.getUserId(), param.getAreaCode(), param.getAreaName());
                    // 站内 跳转协议-
                    protocol = ProtocolFactory.appH5().url(url).build();

                } else {
                    // 跳转应用宝
                    protocol = newsContentReplaceProperties.getLotteryFlauntUrl();
                    // 覆盖设置text
                    el.text(newsContentReplaceProperties.getLotteryFlauntText());
                }

                log.info("替换帖子中，炫耀帖子的跳转协议: {}", protocol);

                // 新增一个href属性
                el.attr(START, protocol);
            });
        }
    }

    @Override
    public ForumContentPlaceHolderEnum[] supports() {
        return new ForumContentPlaceHolderEnum[]{LOTTERY_FLAUNT_JUMP_URL};
    }
}
