package com.bxm.localnews.news.content.replace.html;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.bxm.localnews.news.model.param.ReplaceTopicNeedParam;
import com.bxm.localnews.url.ProtocolFactory;
import lombok.extern.slf4j.Slf4j;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.function.Supplier;

import static com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum.TOPIC_JUMP_URL;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * 话题跳转
 *
 * @author gonzo
 * @date 2020-09-24 18:45
 **/
@Slf4j
@Component
public class TopicJumpUrlReplace extends AbstractHtmlContentReplace {

    private static final String TOPIC_JUMP_URL_SELECT = "a[" + TOPIC_JUMP_URL.getPlaceHolder() + "]";

    @Override
    protected void doReplace(ContentContext context) {
        Elements elements;
        if (!(elements = context.getDocument().select(TOPIC_JUMP_URL_SELECT)).isEmpty()) {

            // 迭代
            elements.forEach(e -> {
                // 获取话题id
                String topicId = e.attr(TOPIC_JUMP_URL.getPlaceHolder());
                if (isNotBlank(topicId)) {
                    // 存在需要替换的a标签

                    // 获取替换需要的参数
                    Supplier<ReplaceTopicNeedParam> basicParamSupplier = context.getReplaceValue(supports()[0]);
                    ReplaceTopicNeedParam param = basicParamSupplier.get();

                    // 判断是站内还是站外
                    String protocol;
                    if (Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform())
                            || Objects.equals(PlatformEnum.IOS.getCode(), param.getPlatform())) {
                        protocol = ProtocolFactory.topic().app().topicId(Long.valueOf(topicId)).build();
                    } else {
                        protocol = ProtocolFactory.topic().outer()
                                .userId(param.getUserId())
                                .areaName(param.getAreaCode())
                                .areaName(param.getAreaName())
                                .topicId(Long.valueOf(topicId))
                                .build();
                    }

                    if (log.isDebugEnabled()) {
                        log.debug("帖子的话题跳转，获取到的跳转协议: {}", protocol);
                    }

                    // 新增一个href属性
                    e.attr(START, protocol);
                }
            });
        }
    }

    @Override
    public ForumContentPlaceHolderEnum[] supports() {
        return new ForumContentPlaceHolderEnum[]{TOPIC_JUMP_URL};
    }
}
