package com.bxm.localnews.news.content.replace.html;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import com.bxm.localnews.news.model.param.ReplaceTopicNeedParam;
import com.bxm.localnews.url.ProtocolFactory;
import lombok.extern.slf4j.Slf4j;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.function.Supplier;

import static com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum.USER_JUMP_URL;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author gonzo
 * @ 用户的主页跳转地址
 * @date 2020-09-24 18:45
 **/
@Slf4j
@Component
public class UserHomePageJumpUrlReplace extends AbstractHtmlContentReplace {

    private static final String USER_JUMP_URL_SELECT = "a[" + USER_JUMP_URL.getPlaceHolder() + "]";

    @Override
    protected void doReplace(ContentContext context) {
        Elements elements;
        if (!(elements = context.getDocument().select(USER_JUMP_URL_SELECT)).isEmpty()) {

            // 迭代所有符合条件的标签
            elements.forEach(element -> {
                String userIdStr = element.attr(USER_JUMP_URL.getPlaceHolder());
                if (isNotBlank(userIdStr)) {

                    // 获取替换需要的参数
                    Supplier<ReplaceTopicNeedParam> basicParamSupplier = context.getReplaceValue(supports()[0]);
                    ReplaceTopicNeedParam param = basicParamSupplier.get();

                    // 判断是站内还是站外
                    String protocol;
                    if (Objects.equals(PlatformEnum.ANDROID.getCode(), param.getPlatform())
                            || Objects.equals(PlatformEnum.IOS.getCode(), param.getPlatform())) {
                        // 站内 跳转协议
                        protocol = ProtocolFactory.home().app()
                                .userId(Long.valueOf(userIdStr))
                                .build();
                    } else {
                        protocol = ProtocolFactory.home().outer().userId(Long.valueOf(userIdStr))
                                .targetUserId(param.getUserId())
                                .areaCode(param.getAreaCode())
                                .areaName(param.getAreaName())
                                .build();
                    }

                    if (log.isDebugEnabled()) {
                        log.debug("用户的主页跳转地址替换，最终用户的跳转协议: {}", protocol);
                    }

                    // 新增一个href属性
                    element.attr(START, protocol);
                }
            });
        }
    }

    @Override
    public ForumContentPlaceHolderEnum[] supports() {
        return new ForumContentPlaceHolderEnum[]{USER_JUMP_URL};
    }
}
