package com.bxm.localnews.news.content.replace.string;

import com.bxm.localnews.news.content.replace.AbstractContentReplace;
import com.bxm.localnews.news.model.dto.ContentContext;
import com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum;
import org.springframework.stereotype.Component;

import static com.bxm.localnews.news.model.enums.ForumContentPlaceHolderEnum.*;

/**
 * 默认的实现 就是直接把占位符替换
 * 具体的占位符替换代码在 {@link AbstractContentReplace#doReplace(ContentContext)} 中实现
 *
 * @author gonzo
 * @date 2020-09-24 18:40
 **/
@Component
public class DefaultContentReplace extends AbstractStringContentReplace {

    @Override
    public ForumContentPlaceHolderEnum[] supports() {
        return new ForumContentPlaceHolderEnum[]{AREA_NAME, AREA_NAME_2, USER_NAME, USER_NAME_2};
    }
}
