package com.bxm.localnews.news.convert;

import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.model.dto.ForumPostCreateDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @author zhaoyadong 2019/7/4 15:12
 * @desc
 */
@Component
public class ForumPostCreateConvert {

    @Autowired
    private IUrlFactory iUrlFactory;

    public ForumPostCreateDTO generateForumPost(ForumPostVo forumPostVo, NewsCompleTaskDTO newsCompleTaskDTO, Long userId) {
        ForumPostCreateDTO.ForumPost forumPost = new ForumPostCreateDTO.ForumPost();
        forumPost.setId(forumPostVo.getId());
        if (CollectionUtils.isNotEmpty(forumPostVo.getPostImgList())) {
            forumPost.setPostImgUrl(forumPostVo.getPostImgList().get(0).getImgUrl());
        }
        forumPost.setTextField(forumPostVo.getTextField());
        forumPost.setTitle(forumPostVo.getTitle());

        ForumPostCreateDTO forumPostCreateDTO = new ForumPostCreateDTO();
        forumPostCreateDTO.setGoldNum(Objects.isNull(newsCompleTaskDTO.getGoldNum()) ? 0 : newsCompleTaskDTO.getGoldNum());
        forumPostCreateDTO.setTaskName(newsCompleTaskDTO.getTaskName());
        forumPostCreateDTO.setTotalGold(newsCompleTaskDTO.getTotalGold());
        forumPostCreateDTO.setShareUrl(iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), userId));
        forumPostCreateDTO.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), userId));
        forumPostCreateDTO.setForumPost(forumPost);
        return forumPostCreateDTO;
    }

}
