package com.bxm.localnews.news.create;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.newidea.component.vo.Message;

/**
 * 帖子创建保存相关的服务接口
 *
 * @author liujia
 * @date 1/15/21 2:16 PM
 **/
public interface PostCreateService {

    /**
     * 保存用户发帖，如果存在帖子ID则进行编辑
     *
     * @param forumBasicVo     帖子信息
     * @param basicParam       发帖的请求对应的基础参数
     * @param isDirectlyPassed 发帖是否直接通过
     * @return 保存结果
     */
    Message saveUserPost(ForumBasicVo forumBasicVo, BasicParam basicParam, boolean isDirectlyPassed);

    /**
     * 用户发布小纸条
     *
     * @param noteParam 发布小纸条的参数
     * @return 小纸条发布结果
     */
    Message saveUserNote(NoteParam noteParam);

    /**
     * 保存运营发帖，如果存在帖子ID则进行编辑处理
     * 运营发帖定制化程度更高
     *
     * @param adminForumPost 运营帖子信息
     * @param operator       选择的发帖用户
     * @return 保存结果
     */
    Message saveAdminPost(AdminForumPost adminForumPost, Long operator);

}
