package com.bxm.localnews.news.create.context;

import com.bxm.localnews.news.model.vo.AdminForumPost;
import lombok.Data;

/**
 * 运营后台发帖的相关上下文
 *
 * @author liujia
 * @date 1/18/21 3:14 PM
 **/
@Data
public class AdminPostContext {

    /**
     * 请求的帖子参数
     */
    private AdminForumPost requestPost;

    /**
     * 如果是编辑，为前一个帖子
     */
    private AdminForumPost beforePost;

    /**
     * 最终入库的帖子信息
     */
    private AdminForumPost savePost;

    /**
     * 运营账号ID
     */
    private Long operator;

    /**
     * 前置检查出错的提示消息
     */
    private String errorMsg;

    /**
     * 当前是新增还是更新操作，true表示为新增
     */
    private boolean saveOrUpdate;

    /**
     * 是否为更新帖子
     *
     * @return true表示为更新
     */
    public boolean isUpdatePost() {
        return !saveOrUpdate;
    }
}
