package com.bxm.localnews.news.create.context;

import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NoteVo;
import com.bxm.localnews.news.vo.UserBean;
import lombok.Data;

/**
 * 用户小纸条创建相关上下文
 *
 * @author liujia
 * @date 1/18/21 4:57 PM
 **/
@Data
public class UserNoteContext {
    /**
     * 原始的创建请求参数
     */
    private NoteParam param;

    /**
     * 最终入库的小纸条信息（共用帖子的实体）
     */
    private ForumPostVo saveNote;

    /**
     * 响应给客户端的小纸条信息
     */
    private NoteVo responseNote;

    /**
     * 前置检查出错的相关提示消息
     */
    private String errorMsg;

    /**
     * 发小纸条的用户信息
     */
    private UserBean postUserInfo;
}
