package com.bxm.localnews.news.create.context;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.UserBean;
import lombok.Data;

/**
 * 用户发帖处理的相关上下文
 *
 * @author liujia
 * @date 1/15/21 2:31 PM
 **/
@Data
public class UserPostContext {

    /**
     * 用户提交的帖子信息
     */
    private ForumBasicVo requestPost;

    /**
     * 如果是更新，获取之前的帖子信息
     */
    private ForumPostVo beforePost;

    /**
     * 最终入库的帖子信息
     */
    private ForumPostVo savePost;

    /**
     * 当前是新增还是更新操作，true表示为新增
     */
    private boolean saveOrUpdate;

    /**
     * 发帖人信息
     */
    private UserBean postUserInfo;

    /**
     * 不需要审核，直接通过的帖子（内部逻辑直接触发发帖的情况）
     */
    private boolean directlyPassed;

    /**
     * 是否用户的首次发帖,true表示为改用户首次发帖
     */
    private boolean firstUserPost;

    /**
     * 用户发帖失败的错误提示消息
     */
    private String errorMsg;

    /**
     * 请求的基础参数，可能为空
     */
    private BasicParam basicParam;

    /**
     * 是否为更新帖子
     *
     * @return true表示为更新
     */
    public boolean isUpdatePost() {
        return !saveOrUpdate;
    }
}
