package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.news.activity.ActivityPostService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

import static com.bxm.localnews.news.constant.LogicGroupConstant.ADMIN_POST_CREATE_FILTER;

/**
 * 运营发布活动贴，额外保存活动贴数据
 *
 * @author liujia
 * @date 1/18/21 9:08 PM
 **/
@FilterBean(group = ADMIN_POST_CREATE_FILTER)
@AllArgsConstructor
@Slf4j
public class AdminPostActivityFilter implements IFilter<AdminPostContext> {

    private ActivityPostService activityPostService;

    @Override
    public void doFilter(AdminPostContext context) {
        AdminForumPost savePost = context.getSavePost();
        if (Objects.isNull(savePost.getActivityPost()) || Objects.equals(savePost.getActivityPost(), 0)) {
            log.debug("[{}]不是活动贴，不予处理", savePost.getId());
            return;
        }

        ForumPostActivityEntity activityEntity = new ForumPostActivityEntity();

        activityEntity.setPostId(savePost.getId());
        activityEntity.setJoinText(savePost.getJoinText());
        activityEntity.setGoodsId(savePost.getGoodsId());
        activityEntity.setStatus(savePost.getActivityStatus());
        activityEntity.setActivityType(savePost.getActivityType());
        activityEntity.setCreator(context.getOperator());

        activityPostService.save(activityEntity);
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
