package com.bxm.localnews.news.create.filter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;

import static com.bxm.localnews.news.constant.LogicGroupConstant.ADMIN_POST_CREATE_FILTER;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * 运营发帖的相关插件处理
 *
 * @author liujia
 * @date 1/18/21 3:36 PM
 **/
@FilterBean(group = ADMIN_POST_CREATE_FILTER)
@AllArgsConstructor
public class AdminPostPluginFilter implements IFilter<AdminPostContext> {

    @Override
    public void doFilter(AdminPostContext context) {
        AdminForumPost savePost = context.getSavePost();

        JSONArray json = new JSONArray();
        if (isNotBlank(savePost.getVotePluginId())) {
            JSONObject votePluginJson = new JSONObject();
            votePluginJson.put("type", "VOTE");
            votePluginJson.put("id", savePost.getVotePluginId());
            json.add(votePluginJson);

            savePost.setPlugins(json.toJSONString());
        } else {
            savePost.setPlugins("");
        }
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
