package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.AdminPostContext;
import com.bxm.localnews.news.domain.AdminTopicMapper;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.localnews.news.post.ForumPostService;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Joiner;
import lombok.AllArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.util.Calendar;
import java.util.Collections;
import java.util.Objects;

import static com.bxm.localnews.news.constant.LogicGroupConstant.ADMIN_POST_CREATE_FILTER;

/**
 * 填充运营发帖的话题信息
 *
 * @author liujia
 * @date 1/18/21 3:36 PM
 **/
@FilterBean(group = ADMIN_POST_CREATE_FILTER)
@AllArgsConstructor
public class AdminPostTopicFillFilter implements IFilter<AdminPostContext> {

    private ForumProperties forumProperties;

    private AdminTopicMapper adminTopicMapper;

    private ForumPostService forumPostService;

    @Override
    public void doFilter(AdminPostContext context) {
        AdminForumPost savePost = context.getSavePost();

        // 如果是小纸条，默认设置话题为小纸条
        if (Objects.equals(PostTypeEnum.NOTE.getCode(), savePost.getPostType())) {
            savePost.setTopicIdList(Collections.singletonList(forumProperties.getNoteTopicId()));
            savePost.setValidDate(DateUtils.addField(savePost.getDisplayTime(), Calendar.DAY_OF_MONTH, savePost.getValidDay()));
        }

        // 设置话题对应的文案
        if (CollectionUtils.isNotEmpty(savePost.getTopicIdList())) {
            AdminTopic adminTopic = adminTopicMapper.selectByPrimaryKey(savePost.getTopicIdList().get(0));
            if (adminTopic != null) {
                savePost.setForumContent(adminTopic.getContent());
            }
            savePost.setTopicIds(Joiner.on(",").join(savePost.getTopicIdList()));
        } else {
            savePost.setTopicIds(StringUtils.EMPTY);
        }

        // 重置帖子的话题
        forumPostService.updateTopic(savePost.getId(), savePost.getTopicIdList(), null);
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
