package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.integration.NewsSeqComponent;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserNoteContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.util.AreaCodeUtils;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.InputFilter;
import com.google.common.base.Joiner;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;

import static com.bxm.localnews.news.constant.LogicGroupConstant.USER_NOTE_CREATE_FILTER;

/**
 * 将小纸条信息转化为帖子的实体，后续进行保存
 *
 * @author liujia
 * @date 1/15/21 2:30 PM
 **/
@FilterBean(group = USER_NOTE_CREATE_FILTER)
@Slf4j
@AllArgsConstructor
public class UserNotePreFillFilter implements IFilter<UserNoteContext> {

    private NewsSeqComponent newsSeqComponent;

    private ForumProperties forumProperties;

    @Override
    public void doFilter(UserNoteContext context) {
        NoteParam noteParam = context.getParam();
        Date currentTime = new Date();

        ForumPostVo forumPostVo = new ForumPostVo();
        BeanUtils.copyProperties(noteParam, forumPostVo);
        forumPostVo.setPostType(PostTypeEnum.NOTE.getCode());
        forumPostVo.setStatus(PostStatusEnum.APPROVING.getCode());
        forumPostVo.setId(newsSeqComponent.getPostId());

        //emoji表情编码替换，输入内容过滤
        String noteText = noteParam.getTextField();
        noteText = EmojiCodeParser.replaceSoftbankEmoji(noteText);
        noteText = InputFilter.builder(noteText).filte();

        forumPostVo.setTextField(noteText);
        forumPostVo.setContent(noteText);

        forumPostVo.setDeliveryType(0);
        if (StringUtils.isNotBlank(forumPostVo.getAreaCode())) {
            forumPostVo.setDeliveryType(1);
            forumPostVo.setAreaCode(AreaCodeUtils.completeAreaCode(forumPostVo.getAreaCode()));
        }

        //默认小纸条话题
        forumPostVo.setTopicIdList(Collections.singletonList(forumProperties.getNoteTopicId()));
        forumPostVo.setTopicIds(Joiner.on(",").join(forumPostVo.getTopicIdList()));
        forumPostVo.setValidDate(DateUtils.addField(new Date(), Calendar.DAY_OF_MONTH, forumPostVo.getValidDay()));

        // 填充基础属性
        UserBean user = context.getPostUserInfo();
        forumPostVo.setUserImg(user.getHeadImg());
        forumPostVo.setUserName(user.getNickname());
        forumPostVo.setCreateTime(currentTime);
        forumPostVo.setDisplayDateTime(currentTime);
        forumPostVo.setPublishTime(currentTime);
        forumPostVo.setModifyTime(currentTime);

        context.setSaveNote(forumPostVo);
    }


    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
