package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserNoteContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NoteVo;
import com.bxm.localnews.news.note.NoteService;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;

import static com.bxm.localnews.news.constant.LogicGroupConstant.USER_NOTE_CREATE_FILTER;

/**
 * 组装返回给客户端需要的小纸条对象
 *
 * @author liujia
 * @date 1/15/21 2:30 PM
 **/
@FilterBean(group = USER_NOTE_CREATE_FILTER)
@AllArgsConstructor
public class UserNoteResponseFilter implements IFilter<UserNoteContext> {

    private NoteService noteService;

    @Override
    public void doFilter(UserNoteContext context) {
        ForumPostVo forumPostVo = context.getSaveNote();

        //返回小纸条实体
        NoteVo noteVo = new NoteVo();
        noteVo.setId(forumPostVo.getId());
        noteVo.setUserId(forumPostVo.getUserId());
        noteVo.setUserImg(forumPostVo.getUserImg());
        noteVo.setTextField(forumPostVo.getTextField());
        noteVo.setValidDay(forumPostVo.getValidDay());
        noteVo.setDisplayTime(forumPostVo.getDisplayDateTime());

        noteService.completeNoteInfo(noteVo, context.getParam().getUserId());

        context.setResponseNote(noteVo);
    }


    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
