package com.bxm.localnews.news.create.filter;

import com.bxm.localnews.integration.NewsSeqComponent;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;
import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSONString;
import static com.bxm.localnews.news.constant.LogicGroupConstant.USER_POST_CREATE_FILTER;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * 如果是用户编辑帖子，进行部分处理操作
 *
 * @author liujia
 * @date 1/15/21 2:30 PM
 **/
@FilterBean(group = USER_POST_CREATE_FILTER)
@Slf4j
@AllArgsConstructor
public class UserPostAttributeFillFilter implements IFilter<UserPostContext> {

    private NewsSeqComponent newsSeqComponent;

    @Override
    public void doFilter(UserPostContext context) {
        ForumPostVo forumPostVo = context.getSavePost();
        if (context.isUpdatePost()) {
            //增加用户修改标识
            if (!Objects.equals(context.getBeforePost().getStatus(), PostStatusEnum.APPROVING.getCode())) {
                forumPostVo.setIsUserUpdate((byte) 1);
            }
            forumPostVo.setIsRecommend((byte) 0);
            forumPostVo.setModifyTime(new Date());
        } else {
            if (null == forumPostVo.getId()) {
                forumPostVo.setId(newsSeqComponent.getPostId());
            }

            if (null != context.getPostUserInfo()) {
                UserBean user = context.getPostUserInfo();
                if (isBlank(user.getHeadImg()) || isBlank(user.getNickname())) {
                    log.info("帖子保存用户头像或昵称为空,userInfo：{}", toJSONString(user));
                }

                forumPostVo.setUserImg(user.getHeadImg());
                forumPostVo.setUserName(user.getNickname());
            }
            Date currentTime = new Date();
            forumPostVo.setCreateTime(currentTime);

            if (null == forumPostVo.getDisplayDateTime()) {
                forumPostVo.setDisplayDateTime(currentTime);
            }
            if (null == forumPostVo.getPublishTime()) {
                forumPostVo.setPublishTime(currentTime);
            }
            if (null == forumPostVo.getModifyTime()) {
                forumPostVo.setModifyTime(currentTime);
            }
        }
    }


    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
