package com.bxm.localnews.news.create.process;

import com.bxm.localnews.news.model.enums.SpecialForumEnum;
import com.bxm.localnews.news.model.param.PostProcessContext;
import com.bxm.newidea.component.vo.Message;

/**
 * 帖子发布处理器
 *
 * @author gonzo
 * @date 2020-11-25 15:55
 **/
public interface PostProcess {

    /**
     * 发帖参数
     *
     * @param context 上下文信息
     * @return 发帖结果
     */
    Message post(PostProcessContext context);

    /**
     * 当前处理器支持的帖子类型
     *
     * @return 当前处理器支持的帖子类型
     */
    SpecialForumEnum support();
}
