package com.bxm.localnews.news.create.process.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.create.process.PostProcess;
import com.bxm.localnews.news.model.param.PostProcessContext;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gonzo
 * @date 2020-11-25 16:01
 **/
@Slf4j
public abstract class AbstractPostProcess implements PostProcess {

    @Override
    public Message post(PostProcessContext context) {
        try {
            return doPost(context);
        } catch (Exception e) {
            log.error("发帖失败, context: {}", JSON.toJSONString(context), e);
        }
        return Message.build(false, "发帖失败");
    }

    /**
     * 真正执行的方法
     *
     * @param context 上下文
     * @return 执行结果
     */
    protected abstract Message doPost(PostProcessContext context);

}
