package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.integration.SensitiveWordService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserNoteContext;
import com.bxm.localnews.news.model.param.NoteParam;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import com.bxm.newidea.component.tools.CharUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import javax.annotation.Resource;

import static com.bxm.localnews.news.constant.LogicGroupConstant.USER_NOTE_CREATE_RULE;

/**
 * 用户发布小纸条的相关前置判断
 *
 * @author liujia
 * @date 1/15/21 3:28 PM
 **/
@RuleBean(group = USER_NOTE_CREATE_RULE)
@Slf4j
public class UserNoteCheckRule implements IRule<UserNoteContext> {

    @Resource
    private SensitiveWordService sensitiveWordService;

    @Override
    public boolean apply(UserNoteContext context) {
        NoteParam noteParam = context.getParam();

        if (null == noteParam || null == noteParam.getUserId() || StringUtils.isEmpty(noteParam.getTextField())
                || null == noteParam.getValidDay()) {
            context.setErrorMsg("缺少必要参数");
            return false;
        }
        if (StringUtils.isBlank(noteParam.getTextField())) {
            context.setErrorMsg("发布内容为空");
            return false;
        }
        if (CharUtil.getWordCount(noteParam.getTextField()) > 50) {
            context.setErrorMsg("发布内容过长");
            return false;
        }
        if (sensitiveWordService.contains(noteParam.getTextField())) {
            context.setErrorMsg("含有敏感词，请重新编辑");
            return false;
        }

        // 3.4.0移除发布次数限制

        return true;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
