package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;

import javax.annotation.Resource;
import java.util.Objects;

import static com.bxm.localnews.news.constant.LogicGroupConstant.USER_POST_CREATE_RULE;

/**
 * 判断用户是否已经发放过新人贴
 *
 * @author liujia
 * @date 1/15/21 3:28 PM
 **/
@RuleBean(group = USER_POST_CREATE_RULE)
public class UserPostNewbieRule implements IRule<UserPostContext> {

    @Resource
    private ForumPostMapper forumPostMapper;

    @Override
    public boolean apply(UserPostContext userPostContext) {
        if (userPostContext.isUpdatePost()) {
            userPostContext.setFirstUserPost(false);
        } else {
            // 已经发过帖子
            boolean posted = forumPostMapper.selectPublishPostNumByUserId(userPostContext.getRequestPost().getUserId()) != 0;

            userPostContext.setFirstUserPost(!posted);

            // 判断用户是否首次发帖
            if (Objects.equals(userPostContext.getRequestPost().getIsNewReport(), 1) && posted) {
                // 返回错误信息
                userPostContext.setErrorMsg("新人帖子只可以发送一次哦~");
                return false;
            }
        }
        return true;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
