package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.integration.SensitiveWordService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

import static com.bxm.localnews.news.constant.LogicGroupConstant.USER_POST_CREATE_RULE;

/**
 * 用户发帖的敏感词判断
 *
 * @author liujia
 * @date 1/15/21 3:28 PM
 **/
@RuleBean(group = USER_POST_CREATE_RULE)
@Slf4j
public class UserPostSensitiveWordRule implements IRule<UserPostContext> {

    @Resource
    private SensitiveWordService sensitiveWordService;

    @Override
    public boolean apply(UserPostContext userPostContext) {
        if (sensitiveWordService.contains(userPostContext.getRequestPost().getTextField())) {
            userPostContext.setErrorMsg("发布内容包含敏感词");
            return false;
        }
        return true;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
