package com.bxm.localnews.news.create.rule;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.create.context.UserPostContext;
import com.bxm.localnews.news.model.vo.ForumBasicVo;
import com.bxm.localnews.news.model.vo.HotForumPostVo;
import com.bxm.localnews.news.post.HotPostService;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;
import lombok.AllArgsConstructor;

import java.util.List;
import java.util.Objects;

import static com.bxm.localnews.news.constant.LogicGroupConstant.USER_POST_CREATE_RULE;

/**
 * 用户编辑帖子时，检查当前状态是否允许编辑
 *
 * @author liujia
 * @date 1/15/21 4:39 PM
 **/
@RuleBean(group = USER_POST_CREATE_RULE)
@AllArgsConstructor
public class UserPostStatusCheckRule implements IRule<UserPostContext> {

    private final HotPostService hotPostService;

    @Override
    public boolean apply(UserPostContext userPostContext) {
        if (userPostContext.isUpdatePost()) {
            ForumBasicVo forumBasicVo = userPostContext.getRequestPost();
            //3.9.0需求 热门帖子不允许编辑
            if (Objects.nonNull(forumBasicVo.getAreaCode())) {
                List<HotForumPostVo> hotForumList = hotPostService.getHotForumList(forumBasicVo.getAreaCode());
                for (HotForumPostVo hotForumPostVo : hotForumList) {
                    if (Objects.equals(hotForumPostVo.getId(), forumBasicVo.getId())) {
                        userPostContext.setErrorMsg("帖子已上热门内容榜，暂时不支持编辑");
                        return false;
                    }
                }
            }

            //无法修改推荐库中内容
            if (Objects.equals(userPostContext.getBeforePost().getIsRecommend(), 1)) {
                userPostContext.setErrorMsg("您的内容已被推荐到头条，如需修改请联系客服");
                return false;
            }
        }

        return true;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
