package com.bxm.localnews.news.detail;

import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.context.PostDetailOriginalParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;

/**
 * 社区帖子详情获取服务接口
 *
 * @author liujia
 * @date 1/13/21 9:10 PM
 **/
public interface ForumPostDetailService {

    /**
     * 获取帖子详情，对历史的获取帖子详情进行兼容，包含较为复杂的逻辑
     * <li> 获取条件过滤
     * <li> 帖子详情填充
     * <li> 后续逻辑处理
     *
     * @param param 原始请求参数
     * @return 帖子详情, 如果不符合规则将直接返回空对象
     */
    ForumPostVo get(PostDetailOriginalParam param);

    /**
     * 自定义获取帖子详情
     *
     * @param context 获取详情的上下文参数
     * @return 帖子详情，根据上下文情况进行组装
     */
    ForumPostVo get(ForumPostDetailContext context);

    /**
     * 获取帖子的简略信息
     *
     * @param postId   帖子ID
     * @param userId   请求用户，可选参数
     * @param areaCode 请求来源地区，可选参数
     * @return 帖子信息，不包含详情部分，不包含用户相关的状态数据，不包含评论等数据
     */
    ForumPostVo getBriefPost(Long postId, Long userId, String areaCode);
}
