package com.bxm.localnews.news.detail.context;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.filter.IFilter;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 社区帖子详情获取上下文
 *
 * @author liujia
 * @date 1/13/21 9:18 PM
 **/
@Data
public class ForumPostDetailContext {

    /**
     * 原始请求信息
     */
    private final PostDetailOriginalParam originalParam;

    /**
     * 请求对应的帖子信息
     */
    private ForumPostVo postInfo;

    /**
     * 请求用户的地区信息
     */
    private LocationDTO location;

    /**
     * 是否填充小纸条的标题
     */
    private Boolean fillNoteTitle;

    /**
     * 跳过不处理的过滤器
     */
    private List<Class<? extends IFilter>> skipFilterList;

    /**
     * 指定选择的过滤器，不在选定列表中的过滤器将不执行
     */
    private List<Class<? extends IFilter>> choiceFilterList;

    /**
     * 设定不执行的过滤器，减少不必要的调用
     *
     * @param filterClass 跳过不执行的过滤器class
     * @return 当前上下文
     */
    public ForumPostDetailContext skipFilter(Class<? extends IFilter> filterClass) {
        if (skipFilterList == null) {
            skipFilterList = new ArrayList<>();
        }
        skipFilterList.add(filterClass);
        return this;
    }

    /**
     * 强制指定执行的过滤器，反选模式
     *
     * @param filterClass 指定执行的过滤器
     * @return 当前上下文
     */
    public ForumPostDetailContext choiceFilter(Class<? extends IFilter> filterClass) {
        if (choiceFilterList == null) {
            choiceFilterList = new ArrayList<>();
        }
        choiceFilterList.add(filterClass);
        return this;
    }

    /**
     * 当前请求是否来自站外
     *
     * @return true表示来自站外H5
     */
    public boolean isOutSide() {
        return Objects.equals(originalParam.getBasicParam().getPlatform(), PlatformEnum.WEB.getCode());
    }

    public Integer getPostStatus() {
        return postInfo.getStatus();
    }

    public Long getPostId() {
        return postInfo.getId();
    }

    public Long getUserId() {
        return originalParam.getUserId();
    }

    public String getAreaCode() {
        return originalParam.getAreaCode();
    }

    public void setEmptyPost() {
        ForumPostVo emptyForumPostVo = new ForumPostVo();
        emptyForumPostVo.setStatus(100);
        emptyForumPostVo.setId(getPostId());
        this.postInfo = emptyForumPostVo;
    }
}
