package com.bxm.localnews.news.detail.context;

import com.bxm.localnews.common.vo.BasicParam;
import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Tolerate;

/**
 * 原始的帖子详情请求参数
 *
 * @author liujia
 * @date 1/14/21 9:54 AM
 **/
@Data
@Builder
@ToString
public class PostDetailOriginalParam {
    @Tolerate
    public PostDetailOriginalParam() {
    }

    @Tolerate
    public PostDetailOriginalParam(Long postId) {
        this.id = postId;
    }

    /**
     * 帖子ID
     */
    private Long id;

    /**
     * 请求用户ID
     */
    private Long userId;

    /**
     * 站外分享用户ID
     */
    private Long shareUserId;

    /**
     * 请求的基础参数，用于区分站内和站外
     */
    private BasicParam basicParam;

    /**
     * 请求区域
     */
    private String areaCode;

    /**
     * 请求IP
     */
    private String ip;
}
