package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.newidea.component.filter.IFilter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 抽象过滤器，提供通用的相关逻辑处理
 *
 * @author liujia
 * @date 1/14/21 11:26 AM
 **/
@Slf4j
public abstract class AbstractPostDetailFilter implements IFilter<ForumPostDetailContext> {

    @Resource
    private LocationIntegrationService locationIntegrationService;

    /**
     * 判断当前过滤器是否被跳过
     *
     * @param context 处理上下文
     * @return true表示跳过
     */
    private boolean skipFilter(ForumPostDetailContext context) {
        if (context.getChoiceFilterList() != null) {
            return !context.getChoiceFilterList().contains(this.getClass());
        }

        if (null != context.getSkipFilterList()) {
            return context.getSkipFilterList().contains(this.getClass());
        }
        return false;
    }

    @Override
    public void doFilter(ForumPostDetailContext context) {
        if (skipFilter(context)) {
            return;
        }

        String areaCode = context.getOriginalParam().getAreaCode();
        if (Objects.nonNull(context.getLocation())) {
            internalDoFilter(context);
        } else {
            if (StringUtils.isBlank(areaCode)) {
                context.setLocation(new LocationDTO());
            } else if (StringUtils.isNotBlank(areaCode) && context.getLocation() == null) {
                LocationDTO location = StringUtils.isNotEmpty(areaCode)
                        ? locationIntegrationService.getLocationByGeocode(areaCode)
                        : null;
                context.setLocation(location);
            }
            internalDoFilter(context);
        }
    }

    /**
     * 执行过滤器
     *
     * @param context 过滤参数上下文
     */
    abstract void internalDoFilter(ForumPostDetailContext context);

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
