package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.activity.ActivityPostService;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.dto.activity.PostActivityExtendDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostActivityEntity;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.newidea.component.annotations.FilterBean;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 加载活动帖子的相关信息
 *
 * @author liujia
 * @date 1/14/21 10:37 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class ActivityPostFillFilter extends AbstractPostDetailFilter {

    @Resource
    private ActivityPostService activityPostService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        if (Objects.equals(forumPostVo.getActivityPost(), 1)) {
            ForumPostActivityEntity detail = activityPostService.getDetail(forumPostVo.getId());

            String protocol = detail.getProtocol();

            // 将活动帖子的协议地址替换为站外访问地址
            if (context.isOutSide() && detail.getGoodsId() != null) {
                LocationDTO locationDTO = context.getLocation();

                protocol = ProtocolFactory.goods().outer()
                        .goodsId(detail.getGoodsId())
                        .areaCode(locationDTO.getCode())
                        .areaName(locationDTO.getName())
                        .inviterId(context.getUserId())
                        .build();
            }

            // 后台状态与API约定不一致，进行转换处理
            int status = Objects.equals(detail.getStatus(), 1) ? 1 : 2;

            forumPostVo.setPostActivityExtendDTO(
                    PostActivityExtendDTO.builder()
                            .activityStatus(status)
                            .joinText(detail.getJoinText())
                            .protocolUrl(protocol)
                            .build()
            );
        }
    }
}
