package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.tools.DateUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;

import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * 基础字段填充与处理的过滤器
 *
 * @author liujia
 * @date 1/14/21 2:15 PM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class BaseInfoFillFilter extends AbstractPostDetailFilter {

    @Resource
    private IUrlFactory iUrlFactory;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        if (isBlank(forumPostVo.getLocation())) {
            LocationDTO locationDTO = context.getLocation();
            forumPostVo.setLocation(null != locationDTO ? locationDTO.getName() : null);
        }

        forumPostVo.setTextField(StringUtils.isNotBlank(forumPostVo.getTextField())
                ? StringEscapeUtils.unescapeHtml(forumPostVo.getTextField())
                : null);

        forumPostVo.setContent(StringUtils.isNotBlank(forumPostVo.getContent())
                ? StringEscapeUtils.unescapeHtml(forumPostVo.getContent())
                : null);

        forumPostVo.setDisplayTime(null != forumPostVo.getDisplayDateTime()
                ? DateUtils.timeConvertString(forumPostVo.getDisplayDateTime())
                : null);

        // 分享到站外的链接地址组装
        forumPostVo.setShareUrl(iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM,
                UrlTypeEnum.SHARE,
                forumPostVo.getId(),
                context.getUserId()));

        // 分享到小程序的链接地址组装
        forumPostVo.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.POST,
                forumPostVo.getId(),
                context.getUserId()));
    }
}
