package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.newidea.component.annotations.FilterBean;

import javax.annotation.Resource;

/**
 * 判断用户是否已经收藏过当前帖子
 *
 * @author liujia
 * @date 1/14/21 10:42 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class CollectFillFilter extends AbstractPostDetailFilter {
    @Resource
    private NewsCollectMapper newsCollectMapper;

    @Override
    public void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        NewsCollect newsCollect = this.newsCollectMapper.selectUserCollect(forumPostVo.getId(), context.getUserId(), (byte) 3);
        forumPostVo.setCollected(null != newsCollect ? 1 : 0);
    }
}
