package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.comment.service.CommentFacadeService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import lombok.AllArgsConstructor;

import java.util.Objects;

/**
 * 评论数量动态计算的过滤器
 *
 * @author liujia
 * @date 1/14/21 2:27 PM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
@AllArgsConstructor
public class CommentCalFilter extends AbstractPostDetailFilter {

    private CommentFacadeService commentFacadeService;

    private ForumProperties forumProperties;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        if (!forumProperties.getEnableAccurateCommentNum()) {
            return;
        }

        //3.9.0 需求 增加了仅用户可见的评论 评论数需要根据用户进行动态计算
        LocationDTO locationDTO = context.getLocation();
        if (Objects.nonNull(locationDTO)) {
            ForumPostVo forumPostVo = context.getPostInfo();
            forumPostVo.setCommentCount(commentFacadeService.replyNum(forumPostVo.getId(),
                    context.getUserId(),
                    locationDTO.getCode()));
        }
    }
}
