package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.AssemblyService;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import org.apache.commons.lang.StringUtils;

import javax.annotation.Resource;

/**
 * 帖子内容组装服务
 *
 * @author liujia
 * @date 1/14/21 2:12 PM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class ContentAssemblyFilter extends AbstractPostDetailFilter {

    @Resource
    private AssemblyService assemblyService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        BasicParam basicParam = context.getOriginalParam().getBasicParam();
        ForumPostVo forumPostVo = context.getPostInfo();
        String ip = context.getOriginalParam().getIp();

        if (StringUtils.equals("1", basicParam.getDevcId()) ||
                PlatformEnum.APPLET.getCode() == basicParam.getPlatform() ||
                PlatformEnum.WEB.getCode() == basicParam.getPlatform()) {
            //取body的内容
            forumPostVo.setContent(assemblyService.fixContent(forumPostVo.getContent(),
                    basicParam, ip, ReplyTypeEnum.POST_REPLY.getCode(),
                    context.getUserId(),
                    context.getAreaCode(),
                    forumPostVo.getId()));
        } else {
            String content = assemblyService.assemblyContent(forumPostVo.getContent(),
                    basicParam, ip, ReplyTypeEnum.POST_REPLY.getCode(),
                    context.getUserId(),
                    context.getAreaCode(),
                    forumPostVo.getId());
            forumPostVo.setContent(content);
        }
    }

    @Override
    public boolean supprtParallel() {
        // 占位符替换与内容替换过滤器冲突，不可并行处理
        return false;
    }
}
