package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import org.apache.commons.lang.StringUtils;

/**
 * 帖子的扩展信息填充，包括：
 * 编辑寄语：帖子内容外的通用性的提示性语句
 * 板块或话题下的通用性额外内容
 *
 * @author liujia
 * @date 1/14/21 10:42 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class ExtendContentFillFilter extends AbstractPostDetailFilter {

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        if (StringUtils.isNotBlank(forumPostVo.getEditorMessage())) {
            forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getEditorMessage());
        }

        if (StringUtils.isNotBlank(forumPostVo.getForumContent())) {
            forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getForumContent());
        }
    }

    @Override
    public boolean supprtParallel() {
        // 需要拼接内容，不可和替换占位符、等内容操作性质的过滤器并行
        return false;
    }
}
