package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.comment.service.CommentFacadeService;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import lombok.AllArgsConstructor;

/**
 * 热门回复信息填充，仅在帖子列表中、话题推荐列表等情况需要展示
 *
 * @author liujia
 * @date 1/14/21 10:42 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
@AllArgsConstructor
public class HotReplayFillFilter extends AbstractPostDetailFilter {

    private CommentFacadeService commentFacadeService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        forumPostVo.setHotReplyDesc(commentFacadeService.getCacheHotReply(forumPostVo.getId(),
                context.getUserId(),
                context.getAreaCode()));
    }
}
