package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.detail.helper.ForumPostImageHelper;
import com.bxm.localnews.news.image.ImageHelper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;

import javax.annotation.Resource;

/**
 * 对帖子的不同图片进行处理
 *
 * @author liujia
 * @date 1/14/21 10:42 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class ImageFillFilter extends AbstractPostDetailFilter {

    @Resource
    private ForumPostImageHelper forumPostImageHelper;

    @Resource
    private ImageHelper imageHelper;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        forumPostVo.setShareImg(forumPostImageHelper.getShareImg(forumPostVo));
        forumPostVo.setPostImgList(imageHelper.getDetailFromPost(forumPostVo.getPostImgList()));

        forumPostVo.setPostContentImgList(forumPostVo.getPostImgList());
    }
}
