package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.domain.ForumPostLikeMapper;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;

import javax.annotation.Resource;

/**
 * 判断用户是否已经点赞过当前帖子
 *
 * @author liujia
 * @date 1/14/21 10:42 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class LikeFillFilter extends AbstractPostDetailFilter {

    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        Integer like = this.forumPostLikeMapper.getUserPostLike(forumPostVo.getId(), context.getUserId());
        forumPostVo.setLiked(null != like && 1 == like ? 1 : 0);
    }
}
