package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.annotations.FilterBean;

import java.util.Collections;
import java.util.Objects;

/**
 * 小纸条处理相关
 *
 * @author liujia
 * @date 1/14/21 2:19 PM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class NoteFillFilter extends AbstractPostDetailFilter {

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        if (Objects.equals(forumPostVo.getPostType(), PostTypeEnum.NOTE.getCode())) {
            //小纸条默认没有标题，是否强制填充标题
            if (Objects.nonNull(context.getFillNoteTitle()) && context.getFillNoteTitle()) {
                forumPostVo.setTitle("我发布了一个纸条");
            }
            forumPostVo.setShareImg(PostImgVo.buildImg(forumPostVo.getUserImg()));
            forumPostVo.setPostImgList(Collections.singletonList(forumPostVo.getShareImg()));
        }
    }
}
