package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.post.ForumPostContentService;
import com.bxm.newidea.component.annotations.FilterBean;

import javax.annotation.Resource;

/**
 * 处理占位符，帖子中存在多区域投放的情况，需要对其中的占位符进行替换处理
 *
 * @author liujia
 * @date 1/14/21 11:05 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class PlaceHolderFilter extends AbstractPostDetailFilter {

    @Resource
    private ForumPostContentService forumPostContentService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        forumPostContentService.replacePlaceHolder(context.getPostInfo(),
                context.getLocation(),
                context.getOriginalParam().getBasicParam(),
                context.getUserId());
    }

    @Override
    public boolean supprtParallel() {
        // 占位符替换与内容替换过滤器冲突，不可并行处理
        return false;
    }
}
