package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.integration.VoteIntegrationService;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ForumPlugin;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.param.VotePinParam;
import com.bxm.newidea.component.annotations.FilterBean;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * 加载帖子的相关插件
 *
 * @author liujia
 * @date 1/14/21 2:29 PM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
@Slf4j
public class PluginLoadFilter extends AbstractPostDetailFilter {

    @Resource
    private VoteIntegrationService voteIntegrationService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        if (log.isDebugEnabled()) {
            log.debug("forumpost:[{}],plugins:[{}]", forumPostVo.getId(), forumPostVo.getPlugins());
        }

        if (forumPostVo.getPlugins() != null) {
            for (ForumPlugin plugin : forumPostVo.getPlugins()) {
                if ("VOTE".equals(plugin.getType())) {
                    VotePinParam param = new VotePinParam();
                    param.setRelationId(forumPostVo.getId());
                    param.setVoteId(plugin.getId());
                    param.setUserId(context.getUserId());

                    forumPostVo.setVoteDetailDTO(voteIntegrationService.get(param));
                    break;
                }
            }
        }
    }
}
