package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.dto.MerchantUserDTO;
import com.bxm.localnews.integration.MerchantRelationService;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import org.springframework.beans.BeanUtils;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 填充发帖人的VIP标记和商户信息
 *
 * @author liujia
 * @date 1/14/21 10:42 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class RelationFillFilter extends AbstractPostDetailFilter {

    @Resource
    private MerchantRelationService merchantRelationService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        forumPostVo.setIsVip(merchantRelationService.isVip(forumPostVo.getUserId()));
        MerchantUserDTO merchantUserDTO = merchantRelationService.getRelationMerchant(forumPostVo.getUserId());
        forumPostVo.setMerchantStatus(0);

        if (Objects.nonNull(merchantUserDTO)) {
            BeanUtils.copyProperties(merchantUserDTO, forumPostVo);
        }
    }

}
