package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.hotpost.ShareCashPostService;
import com.bxm.localnews.news.model.dto.hotpost.ShareCashExtendDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * 如果帖子是热文则加载热文帖子的相关信息
 *
 * @author liujia
 * @date 1/14/21 10:37 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class ShareCashPostFillFilter extends AbstractPostDetailFilter {

    @Resource
    private ShareCashPostService shareCashPostService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        if (Objects.equals(forumPostVo.getShareCash(), 1)) {

            ForumPostShareCashInfoEntity detail = shareCashPostService.getDetail(forumPostVo.getId());

            if (detail.getStatus() == 0) {
                return;
            }
            BigDecimal usedAmount = BigDecimal.ZERO;
            //如果分享数大于0，则最终奖励为真实已发金额 * 2 + 固化的随机数
            if (context.getPostInfo().getShareCount() > 0) {
                BigDecimal randomAmount = redisHashMapAdapter.get(buildHotPostRandomAwardKey(),
                        String.valueOf(context.getPostId()),
                        BigDecimal.class);

                usedAmount = detail.getUsedAmount().multiply(BigDecimal.valueOf(2));
                usedAmount = usedAmount.add(randomAmount);
            }

            forumPostVo.setShareCashExtendDTO(
                    ShareCashExtendDTO.builder()
                            .amount(detail.getAmount())
                            .usedAmount(usedAmount)
                            .build()
            );
        }
    }

    /**
     * 构建热文帖子随机初始已发奖励金额
     *
     * @return redis key
     */
    private KeyGenerator buildHotPostRandomAwardKey() {
        return RedisConfig.HOT_POST_INIT_RANDOM_AWARD_KEY.copy();
    }
}
