package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 帖子显示的标签进行显示修正
 *
 * @author liujia
 * @date 1/14/21 10:37 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class TagSwitchFilter extends AbstractPostDetailFilter {
    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        //如果不是精华，不是爆料，不是现金奖励且是优质头条就设置为红色章
        if (Objects.equals(forumPostVo.getIsBrilliant(), 0)
                && Objects.equals(forumPostVo.getIsBroke(), (byte) 0)
                && Objects.equals(forumPostVo.getIsCash(), 0)
                && Objects.equals(forumPostVo.getIsRecommend(), (byte) 1)) {
            forumPostVo.setIsRed(1);
        }

        // 若黑色章的开关置为【黑色章】，且帖子打上了现金奖励标，则现金奖励标志不显示
        boolean flag = Objects.nonNull(forumPostVo.getIsRed())
                && forumPostVo.getIsRed() == 0
                && Objects.nonNull(forumPostVo.getIsCash())
                && forumPostVo.getIsCash() == 1;

        if (flag) {
            forumPostVo.setIsCash(0);
            forumPostVo.setCashReward(new BigDecimal(0));
        }
    }
}
